﻿/*
VERSION:		1.1

USAGE:
	#include "functions/addWheelScroll.as"
	wheel = addWheelScroll( this );
	this.addEventListener("unload", wheel);

DESCRIPTION:
	If a List component's mouse-wheel scrolling won't work, use this to re-program it.
	This also works on components based on the List component, such as 
		Tree, etc...
	
NOTE:
	This may ignore component focus.
*/
addWheelScroll = function( target )
{
	target.__onMouseWheel = null;		// remove default scrollFunction;
	var wheel = {};
	Mouse.removeListener( wheel );
	Mouse.addListener( wheel );
	wheel.onMouseWheel = function(delta){
		var hasFocus = (target.getFocus() == target)
		if(hasFocus  &&  delta)
		{// if:  this component has focus  &  the wheel has moved
			var dir = delta <= 0 ? (1) : (-1);
			var lineScrollSize = target.vScroller.lineScrollSize;
			if (lineScrollSize == undefined)
				lineScrollSize = 0;
			lineScrollSize = Math.max(Math.abs(delta), lineScrollSize);
			var newPosition = target.vPosition + lineScrollSize * dir;
			target.vPosition = Math.max(0, Math.min(newPosition, target.maxVPosition));
			target.dispatchEvent({type:"scroll", direction:"vertical", position:target.vPosition});
		}// if:  this component has focus  &  the wheel has moved
	}// onMouseWheel()
	wheel.unload = function(){
		Mouse.removeListener( wheel );
	}// unload()
	return wheel;
}// forceScroll